// Initialize global object
(function() {

    if ('undefined' === typeof BRICK) {
        BRICK = {};
    }

    BRICK.current_column_width = 0;

    /**
     * Helper functiond
     */
    function _getDevice() {
        if (window.getComputedStyle) {
            var body = document.querySelector('body');
            var txt = window.getComputedStyle(body, ':after').content;
            if (txt.length > 0 && txt.charAt(0) == '"') {
                txt = txt.substr(1, txt.length - 2);
            }
            return txt;
        } else {
            throw 'Unabled to check current device';
        }
    }

    /**
     * Extends Isotope with special layout for centered masonry container
     * @see http://isotope.metafizzy.co/custom-layout-modes/centered-masonry.html
     */
    function _initIsotope() {
        $.Isotope.prototype._getCenteredMasonryColumns = function() {
            this.width = this.element.width();
            var parentWidth = this.element.parent().width();
            // i.e. options.masonry && options.masonry.columnWidth
            var colW = this.options.masonry && this.options.masonry.columnWidth ||
            // or use the size of the first item
            this.$filteredAtoms.outerWidth(true) ||
            // if there's no items, use size of container
            parentWidth;

            var cols = Math.floor(parentWidth / colW);
            cols = Math.max(cols, 1);

            // i.e. this.masonry.cols = ....
            this.masonry.cols = cols;
            // i.e. this.masonry.columnWidth = ...
            this.masonry.columnWidth = colW;
        };

        $.Isotope.prototype._masonryReset = function() {
            // layout-specific props
            this.masonry = {};
            // FIXME shouldn't have to call this again
            this._getCenteredMasonryColumns();
            var i = this.masonry.cols;
            this.masonry.colYs = [];
            while (i--) {
                this.masonry.colYs.push(0);
            }
        };

        $.Isotope.prototype._masonryResizeChanged = function() {
            var prevColCount = this.masonry.cols;
            // get updated colCount
            this._getCenteredMasonryColumns();
            return (this.masonry.cols !== prevColCount);
        };

        $.Isotope.prototype._masonryGetContainerSize = function() {
            var unusedCols = 0,
                i = this.masonry.cols;
            // count unused columns
            while (--i) {
                if (this.masonry.colYs[i] !== 0) {
                    break;
                }
                unusedCols++;
            }
            return {
                height: Math.max.apply(Math, this.masonry.colYs),
                // fit container to columns that have been used;
                width: (this.masonry.cols - unusedCols) * this.masonry.columnWidth
            };
        };
    };

    /** 
     * Activation de Isotope au delà de 480px à l'aide de la librairie enquire
     * - match pour appeler le plugin isotope
     * - unmatch pour désactiver le plugin
     */
    function _registerIsotope() {

        enquire.register("(min-width: 480px)", {

            // REQUIRED
            // Triggered when the media query transitions
            // *from an unmatched to a matched state*
            match: function() {
                console.log('BRICK.register start');
                var $wall = $(".wall");
                var $bricks = $wall.find(".brick");
                $bricks.show();
                $wall.isotope({
                    // options
                    animationEngine: 'css',
                    layoutMode: 'masonry',
                    itemSelector: '.brick',
                    filter: ':not(.brick--is-filtered)',
                    transformsEnabled: true,
                    resizable: false,
                    masonry: {
                        columnWidth: 184
                    }
                });
                BRICK.current_column_width = 184;
                console.log('BRICK.register end');

                /* Ajoute une callback pour gérer dynamiquement le resize */
                $(window).smartresize(function() {
                    console.log('BRICK.smartresize start');
                    var dev = _getDevice();
                    var cw = 184;
                    switch (dev) {
                        case "palm":
                            ;
                        case "palm-wide":
                            cw = 184;
                            break;
                        case "lap":
                            cw = 196;
                            break;
                        case "lap-wide":
                            cw = 222;
                            break;
                        case "desk":
                            cw = 244;
                            break;
                        case "desk-wide":
                            cw = 270;
                            break;
                        default:
                            throw "Unknown device " + dev;
                            break;
                    }
                    if (cw != BRICK.current_column_width) {
                        $wall.isotope({
                            masonry: {
                                columnWidth: cw
                            }
                        });
                        BRICK.current_column_width = cw;
                    }
                    console.log('BRICK.smartresize end');
                });

            },

            // OPTIONAL, If supplied, triggered when the media query transitions
            // from a matched state to an unmatched state
            unmatch: function() {
                var options = {
                    filter: ''
                };
                $(window).unbind("smartresize"); /* Unbind personal callback */
                var $wall = $(".wall");
                $wall.isotope(options);
                $wall.isotope('destroy');
                $(".wall .brick--is-filtered").hide();
            },

            // OPTIONAL, If supplied, triggered once immediately upon registration of the handler
            setup: function() {},

            // OPTIONAL, defaults to false
            // If set to true, defers execution the setup function
            // until the media query is first matched. still triggered just once
            deferSetup: false

        });

    };


    // Initialisation
    BRICK.init = function() {
        console.log('BRICK.init start');
        _initIsotope();
        _registerIsotope();
        // Show wall
        $(".js .wall").css('visibility', 'visible');
        console.log('BRICK.init end');
    };

    // Rendering
    BRICK.render = function() {
        console.log('BRICK.render start');
        if ($('.isotope').size() > 0) {
            console.log('BRICK.render isotope');
            var options = {
                filter: ':not(.brick--is-filtered)'
            };
            var $wall = $(".wall");
            $wall.isotope(options);
        } else {
            console.log('BRICK.render std');
            $(".wall .brick").show();
            $(".wall .brick--is-filtered").hide();
        }
        console.log('BRICK.render stop');
    }

})();